{********************************************
; File: Resources.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT RESOURCES;
INTERFACE
USES TYPES,MEMORY,GSOS;
CONST


{ ResourceConverter Codes }
resLogOut = $0;
resLogIn = $1;
resLogApp = $0;
resLogSys = $2;

{ Error Codes }
resForkUsed = $1E01;  { Resource fork not empty }
resBadFormat = $1E02;  { Format of resource fork is unknown }
resNoConverter = $1E03;  { No converter routine available for resource type }
resNoCurFile = $1E04;  { there are no current open resource files }
resDupID = $1E05;  { ID is already used }
resNotFound = $1E06;  { resource was not found }
resFileNotFound = $1E07;  { resource file not found }
resBadAppID = $1E08;  { User ID not found, please call ResourceStartup }
resNoUniqueID = $1E09;  { a unique ID was not found }
{$IFC UNDEFINED resIndexRange }  { Index is out of range }
resIndexRange = $1E0A;
{$SETC resIndexRange := 0}
{$ENDC}
resSysIsOpen = $1E0B;  { System file is already open }
resHasChanged = $1E0C;  { Resource marked changed; specified operation not allowed }
resDiffConverter = $1E0D;  { Different converter already logged in for this resource type }
resDiskFull = $1E0E;  { Volume is full }

{ Other Constants }
resChanged = $0020;
resPreLoad = $0040;
resProtected = $0080;
resAbsLoad = $0400;
resConverter = $0800;
resMemAttr = $C31C;  { Flags passed to the NewHandle Memory Manager call }
systemMap = $0001;
mapChanged = $0002;
romMap = $0004;
resNameOffset = $10000;  { type holding names }
resNameVersion = $0001;

{ Resource Type Numbers }
rIcon = $8001;  { Icon type }
rPicture = $8002;  { Picture type }
rControlList = $8003;  { Control list type }
rControlTemplate = $8004;  { Control template type }
rC1InputString = $8005;  { GS/OS class 1 input string }
rPString = $8006;  { Pascal string type }
rStringList = $8007;  { String list type }
rMenuBar = $8008;  { MenuBar type }
rMenu = $8009;  { Menu template }
rMenuItem = $800A;  { Menu item definition }
rTextForLETextBox2 = $800B;  { Data for LineEdit LETextBox2 call }
rCtlDefProc = $800C;  { Control definition procedure type }
rCtlColorTbl = $800D;  { Color table for control }
rWindParam1 = $800E;  { Parameters for NewWindow2 call }
rWindParam2 = $800F;  { Parameters for NewWindow2 call }
rWindColor = $8010;  { Window Manager color table }
rTextBlock = $8011;  { Text block }
rStyleBlock = $8012;  { TextEdit style information }
rToolStartup = $8013;  { Tool set startup record }
rResName = $8014;  { Resource name }
rAlertString = $8015;  { AlertWindow input data }
rText = $8016;  { Unformatted text }
rCodeResource = $8017;
rCDEVCode = $8018;
rCDEVFlags = $8019;
rTwoRects = $801A;  { Two rectangles }
rListRef = $801C;  { List member }
rCString = $801D;  { C string }
rErrorString = $8020;  { ErrorWindow input data }
rKTransTable = $8021;  { Keystroke translation table }
rWString = $8022;
rC1OutputString = $8023;  { GS/OS class 1 output string }
rSoundSample = $8024;
rTERuler = $8025;  { TextEdit ruler information }
rFSequence = $8026;
rCursor = $8027;  { Cursor resource type }

TYPE
ResID = Longint ;
ResType = Integer ;
ResAttr = Integer ;
ResHeaderRec = RECORD
    rFileVersion : Longint; { Format version of resource fork }
    rFileToMap : Longint; { Offset from start to resource map record }
    rFileMapSize : Longint; { Number of bytes map occupies in file }
    rFileMemo : PACKED ARRAY[1..128] OF Byte; { Reserved space for application }
    rFileRecSize : Longint; { Size of ResHeaderRec Record }
END;
FreeBlockRec = RECORD
    blkOffset : Longint;
    blkSize : Longint;
END;
ResMapHndl = ^ResMapPtr;
ResMapPtr = ^ResMap;
ResMap = RECORD
    mapNext : ResMapHndl; { Handle to next resource map }
    mapFlag : Integer; { Bit Flags }
    mapOffset : Longint; { Map's file position }
    mapSize : Longint; { Number of bytes map occupies in file }
    mapToIndex : Integer;
    mapFileNum : Integer;
    mapID : Integer;
    mapIndexSize : Longint;
    mapIndexUsed : Longint;
    mapFreeListSize : Integer;
    mapFreeListUsed : Integer;
    mapFreeList : ARRAY[1..1] OF FreeBlockRec; { n bytes (array of free block records) }
END;
ResRefRecPtr = ^ResRefRec;
ResRefRec = RECORD
    resType : ResType;
    resID : ResID;
    resOffset : Longint;
    resAttr : ResAttr;
    resSize : Longint;
    resHandle : Handle;
END;
ResourceSpec = RECORD
    resourceType : ResType;
    resourceID : ResID;
END;
ResNameEntryPtr = ^ResNameEntry;
ResNameEntry = RECORD
    namedResID : ResID;
    resName : Str255;
END;
ResNameRecHndl = ^ResNameRecPtr;
ResNameRecPtr = ^ResNameRec;
ResNameRec = RECORD
    version : Integer;
    nameCount : Longint;
    resNameEntries : ARRAY[1..1] OF ResNameEntry;
END;
PROCEDURE AddResource ( resourceHandle:Handle; resourceAttr:ResAttr; resourceType:ResType; resourceID:ResID)  ;
PROCEDURE CloseResourceFile ( fileID:Integer)  ;
FUNCTION CountResources ( resourceType:ResType) : Longint ;
FUNCTION CountTypes  : Integer ;
PROCEDURE CreateResourceFile ( auxType:Longint; fileType:Integer; fileAccess:Integer; fileName:GSString255Ptr)  ;
PROCEDURE DetachResource ( resourceType:ResType; resourceID:ResID)  ;
FUNCTION GetCurResourceApp  : Integer ;
FUNCTION GetCurResourceFile  : Integer ;
FUNCTION GetIndResource ( resourceType:ResType; resourceIndex:Longint) : ResID ;
FUNCTION GetIndType ( typeIndex:Integer) : ResType ;
FUNCTION  GetMapHandle ( fileID:Integer) : ResMapHndl ;
FUNCTION GetOpenFileRefNum ( fileID:Integer) : Integer ;
FUNCTION GetResourceAttr ( resourceType:ResType; resourceID:ResID) : ResAttr ;
FUNCTION GetResourceSize ( resourceType:ResType; currentID:ResID) : Longint ;
FUNCTION HomeResourceFile ( resourceType:ResType; resourceID:ResID) : Integer ;
FUNCTION  LoadAbsResource ( loadAddress:Longint; maxSize:Longint; resourceType:ResType; resourceID:ResID) : Longint ;
FUNCTION LoadResource ( resourceType:ResType; resourceID:ResID) : Handle ;
PROCEDURE MarkResourceChange ( changedFlag:Boolean; resourceType:ResType; resourceID:ResID)  ;
PROCEDURE MatchResourceHandle (VAR resourceInfo:ResourceSpec; resourceHandle:Handle)  ;
FUNCTION OpenResourceFile ( openAccess:Integer; resourceMapPtr:ResMapPtr; fileName:GSString255Ptr) : Integer ;
PROCEDURE ReleaseResource ( purgeLevel:Integer; resourceType:ResType; resourceID:ResID)  ;
PROCEDURE RemoveResource ( resourceType:ResType; resourceID:ResID)  ;
PROCEDURE ResourceBootInit   ;
PROCEDURE ResourceConverter ( converterProc:ProcPtr; resourceType:ResType; logFlags:Integer)  ;
PROCEDURE ResourceReset   ;
PROCEDURE ResourceShutDown   ;
PROCEDURE ResourceStartUp ( userID:Integer)  ;
FUNCTION ResourceStatus  : Boolean ;
FUNCTION ResourceVersion  : Integer ;
PROCEDURE SetCurResourceApp ( userID:Integer)  ;
PROCEDURE SetCurResourceFile ( fileID:Integer)  ;
PROCEDURE SetResourceAttr ( resourceAttr:ResAttr; resourceType:ResType; currentID:ResID)  ;
FUNCTION SetResourceFileDepth ( searchDepth:Integer) : Integer ;
PROCEDURE SetResourceID ( newID:ResID; resourceType:ResType; currentID:ResID)  ;
FUNCTION SetResourceLoad ( readFlag:Integer) : Integer ;
FUNCTION UniqueResourceID ( IDrange:Integer; resourceType:ResType) : ResID ;
PROCEDURE UpdateResourceFile ( fileID:Integer)  ;
PROCEDURE WriteResource ( resourceType:ResType; resourceID:ResID)  ;
IMPLEMENTATION
END.
